dofile(LockOn_Options.script_path.."AN_APQ159/indicator/AN_APQ159_definitions.lua")

local half_width	= GetScale()
local half_height	= GetAspect() * half_width
local aspect		= GetAspect() -- GetHalfHeight()/GetHalfWidth()

local tex_scale			= 1/512
local delta				= 10*tex_scale
local elem_scale		= 1/86.2*2 --equals 2/86.2
local elem_delta		= 10/20*elem_scale --equals 1/86.2
local ACQ_offset		= 0 --offset of the acquisition on the radar. Default is -20, 0 is centered. Available range is -30,30. WARNING : Whatever you may set here, clutter in DM/DG modes still always appears at -20.
local IND_MATERIAL		 = "INDICATION_AN_APQ159"
local IND_MATERIAL_SWEEP = "INDICATION_AN_APQ159_SWEEP"

local mil5Scale = 1/9260		-- meter to 5-mile
local milToDeg	= 70/30*7

--[[
radar_159 mode
	NONE		= 0
	STBY		= 1
	SCAN		= 2
	ACQUISITION = 3
	TRACKING	= 4
--]]

SCAN_mode					= CreateElement("ceSimple")
SCAN_mode.name				= "SCAN_mode"
SCAN_mode.element_params	= {	"RADAR159_MODE",
								"ALL_BRIGHTNESS"}
SCAN_mode.controllers		= {	{"parameter_in_range",		0, 1.9, 3.1},
								{"opacity_using_parameter",	1}} -- 	SCAN and ACQUSITION
Add(SCAN_mode)

backgroundLight					= CreateElement "ceMeshPoly" -- untextured shape
backgroundLight.name			= "backgroundLight"
backgroundLight.material		= "INDICATION_COMMON_GREEN"
backgroundLight.vertices		= { {-1, aspect}, { 1,aspect}, { 1,-aspect}, {-1,-aspect}, }
backgroundLight.indices			=  {0,1,2 ;  -- first triangle
								0,2,3 }  -- second
backgroundLight.h_clip_relation	= h_clip_relations.COMPARE  -- check clipping : pixel on glass then increase level from GLASS_LEVEL to GLASS_LEVEL+1 = HUD_DEFAULT_LEVEL
backgroundLight.level			= RADAR_DEFAULT_LEVEL
backgroundLight.element_params	= {"BACK_BRIGHTNESS"}
backgroundLight.controllers		= {{"opacity_using_parameter", 0}}
Add(backgroundLight)

-- Indication STBY and up
-- TODO: Indication SCAN and up ???

-- Horizon Bar
for i = 0,1 do
	horizon_bar					= CreateElement "ceTexPoly"
	horizon_bar.name			= "horizon_bar_"..i
	horizon_bar.init_pos		= {0, 2*elem_scale, 0}
	horizon_bar.init_rot		= {i*180,0,0}				-- Rotate second bar
	horizon_bar.vertices		= { {-(20+5)*elem_scale-elem_delta,	-0.2*elem_scale-elem_delta},
									{-(20+5)*elem_scale-elem_delta,	 0.2*elem_scale+elem_delta},
									{  0*elem_scale+elem_delta,		 0.2*elem_scale+elem_delta},
									{  0*elem_scale+elem_delta,		-0.2*elem_scale-elem_delta}}
	horizon_bar.indices 		= default_box_indices
	horizon_bar.tex_coords		= { {20 * tex_scale-delta,			432 * tex_scale+delta},
									{20 * tex_scale-delta,			408 * tex_scale-delta},
									{(400+100) * tex_scale+delta,	408 * tex_scale-delta},
									{(400+100) * tex_scale+delta,	432 * tex_scale+delta}}
	horizon_bar.material		= IND_MATERIAL
	horizon_bar.use_mipfilter	= use_mipfilter
	horizon_bar.h_clip_relation	= h_clip_relations.COMPARE
	horizon_bar.level			= RADAR_DEFAULT_LEVEL
	horizon_bar.element_params	= {	"RADAR159_MODE",
									"PLANE_PITCH",
									"PLANE_ROLL",
									"CURSOR_BRIGHTNESS"}
	horizon_bar.controllers		= {	{"parameter_in_range",			0, 0.9,4.1},		-- STBY and up
									{"move_up_down_using_parameter",1, (2*i-1)*180/math.pi*elem_scale*0.864*half_height,},		-- -1..1 * 180
									{"rotate_using_parameter",		2},
									{"opacity_using_parameter",		3}}
	Add(horizon_bar)
end

-- B-Sweep / "Normal" radar mode
for i = 0,2 do
	bsweep					= CreateElement "ceTexPoly"
	bsweep.name				= "bsweep_"..i
	bsweep.init_pos			= {(i-1)*90*elem_scale, 0, 0}
	bsweep.init_rot			= {90,0,180*(i-1)} --{90,0,180*(i-1)}
	--Coordinates of B-Sweep on the radar screen / Remember we have a 90° offset, so it's like (Y,X) / Y = b-sweep height ; X = B-sweep travelling range <<-|---->>
	bsweep.vertices			= { {-86.2*elem_delta,	 0*elem_delta}, -- bottom left
								{-86.2*elem_delta,	60*elem_delta}, -- bottom right
								{ 86.2*elem_delta,	60*elem_delta}, -- top right
								{ 86.2*elem_delta,	 0*elem_delta}} -- top left
	bsweep.indices 			= default_box_indices
	--Coordinates of the texture part to use in the tga file / We only take the lower half for normal bsweep. Upper half is for bsweep2.
	-- (0,0) in the tga file is the upper left corner. The texture isn't 90° offset'ed so, (X,Y)
	bsweep.tex_coords		= { { 0 * tex_scale,	512 * tex_scale}, -- bottom left
								{ 0 * tex_scale,	260 * tex_scale}, -- top left
								{512 * tex_scale,	260 * tex_scale}, -- top right
								{512 * tex_scale,	512 * tex_scale}} -- bottom right
	bsweep.material			= IND_MATERIAL_SWEEP
	bsweep.use_mipfilter	= use_mipfilter
	bsweep.h_clip_relation	= h_clip_relations.COMPARE
	bsweep.level			= RADAR_DEFAULT_LEVEL
	bsweep.element_params	= { "RADAR159_MODE",
								"BSWEEP_AZIMUTH",
								"BSWEEP_ROTATION",
								"BSWEEP_mode"}
	bsweep.controllers		= {	{"parameter_in_range",			0, 1.9,4.1},		-- OPER and up
								{"move_up_down_using_parameter",1, 180/math.pi*elem_scale*half_width},
								{"rotate_using_parameter_Z",	2},
								{"parameter_in_range",			3, -0.1, 0.1}}
	Add(bsweep)
end

--B-Sweep mask / looks like it's not really needed. Needs testing in multiplayer (!!! please confirm "spots" still appears below the B-sweep in DM/DG mode !!!).
--bsweep_mask					= CreateElement "ceMeshPoly"
--bsweep_mask.name			= "bsweep_mask"
--bsweep_mask.init_pos		= {0, 15*elem_scale, 0}
--bsweep_mask.init_rot		= {90,0,0}
--bsweep_mask.primitivetype	= "triangles"
----bsweep_mask.vertices		= { {-25*elem_scale-elem_delta,	-5.0*elem_scale-elem_delta},
----								{-25*elem_scale-elem_delta,	 5.0*elem_scale+elem_delta},
----								{ 30*elem_scale+elem_delta,	 5.0*elem_scale+elem_delta},
----								{ 30*elem_scale+elem_delta,	-5.0*elem_scale-elem_delta}}
--bsweep_mask.vertices		= { {-51*elem_delta,	 -11*elem_delta},
--								{-51*elem_delta,	11*elem_delta},
--								{ 61*elem_delta,	11*elem_delta},
--								{ 61*elem_delta,	 -11*elem_delta}}
--bsweep_mask.indices			= default_box_indices
--bsweep_mask.material		= "DBG_RED"
--bsweep_mask.h_clip_relation	= h_clip_relations.INCREASE_LEVEL
--bsweep_mask.level			= RADAR_DEFAULT_LEVEL+1
--bsweep_mask.isvisible		= false
--bsweep_mask.element_params	= { "BSWEEP_zone"}
--bsweep_mask.controllers		= {	{"move_up_down_using_parameter",0, -180/math.pi*elem_scale*half_width}}
--Add(bsweep_mask)

local function sign(i)
	if i==1 then
		return 1
	else
		return -1
	end
end
for i = 0,2 do
--B-Sweep 2 / Is used for DG/DM modes
	bsweep2					= CreateElement "ceTexPoly"
	bsweep2.name			= "bsweep2_"..i
	bsweep2.init_pos		= {ACQ_offset*elem_scale, 0, 0}
	bsweep2.init_rot		= {90, 0, 0} 
	--Coordinates of B-Sweep on the radar screen / Remember we have a 90° offset, so it's like (Y,X) / Y = b-sweep height ; X = B-sweep travelling range <<-|---->>
	bsweep2.vertices		= { {-86.2*elem_delta,	-15*elem_delta}, -- bottom left
								{-86.2*elem_delta,	 15*elem_delta}, -- bottom right
								{ 86.2*elem_delta,	 15*elem_delta}, -- top right
								{ 86.2*elem_delta,	-15*elem_delta}} -- top left
	bsweep2.indices 		= default_box_indices
	--Coordinates of the texture part to use in the tga file / We only take the lower half for normal bsweep. Upper half is for bsweep2.
	-- (0,0) in the tga file is the upper left corner. The texture isn't 90° offset'ed so, (X,Y)
	bsweep2.tex_coords		= { { 0 * tex_scale,	255 * tex_scale},	-- bottom left
								{ 0 * tex_scale,	50 * tex_scale},	-- top left
								{512 * tex_scale,	50 * tex_scale},	-- top right
								{512 * tex_scale,	255 * tex_scale}}	-- bottom right
	bsweep2.material			= IND_MATERIAL_SWEEP
	bsweep2.use_mipfilter	= use_mipfilter
	bsweep2.h_clip_relation	= h_clip_relations.COMPARE
	bsweep2.level			= RADAR_DEFAULT_LEVEL -- was RADAR_DEFAULT_LEVEL+1
--	bsweep2.parent_element	= bsweep_mask.name
	bsweep2.isvisible		= true
	bsweep2.element_params	= { "RADAR159_MODE",
								"BSWEEP_AZIMUTH",
								"BSWEEP_ROTATION",
								"BSWEEP_mode"}
	bsweep2.controllers		= {	{"parameter_in_range",			0, 1.9,4.1},		-- OPER and up
								{"move_up_down_using_parameter",1, 180/math.pi*elem_scale*half_width},
								{"rotate_using_parameter_Z",	2},
								{"parameter_in_range",			3, 0.9, 1.1}}
	Add(bsweep2)
end

-- Antenna Elevation Cursor
antenna_elevation					= CreateElement "ceTexPoly"
antenna_elevation.name				= "antenna_elevation"
antenna_elevation.init_pos			= {1, 0, 0}
antenna_elevation.vertices			= { {-7*elem_scale-elem_delta, -0.3*elem_scale-elem_delta},
										{-7*elem_scale-elem_delta,  0.3*elem_scale+elem_delta},
										{-1*elem_scale+elem_delta,  0.3*elem_scale+elem_delta},
										{-1*elem_scale+elem_delta, -0.3*elem_scale-elem_delta}}
antenna_elevation.indices 			= default_box_indices
antenna_elevation.tex_coords		= { {290 * tex_scale-delta,	155 * tex_scale+delta},
										{290 * tex_scale-delta,	135 * tex_scale-delta},
										{430 * tex_scale+delta,	135 * tex_scale-delta},
										{430 * tex_scale+delta,	155 * tex_scale+delta}}
antenna_elevation.material			= IND_MATERIAL
antenna_elevation.use_mipfilter		= use_mipfilter
antenna_elevation.h_clip_relation	= h_clip_relations.COMPARE
antenna_elevation.level				= RADAR_DEFAULT_LEVEL
antenna_elevation.element_params	= { "RADAR159_MODE",
										"SCAN_ZONE_ELEVATION",
										"CURSOR_BRIGHTNESS"} 
antenna_elevation.controllers		= {	{"parameter_in_range",			0, 0.9,3.1},		-- OPER and up
										{"move_up_down_using_parameter",1, 180/math.pi*elem_scale*0.864*half_height},
										{"opacity_using_parameter",		2}}
Add(antenna_elevation)

-- TDC (Acquisition Symbol)
TDC					= CreateElement("ceSimple")
TDC.name			= "TDC"
TDC.init_pos		= {0, -2.5*milToDeg*elem_scale/0.947, 0}
TDC.parent_element	= SCAN_mode.name
TDC.element_params	= { "SHOW_TDC",
						"RADAR_TDC_AZIMUTH",
						"RADAR_TDC_RANGE_SCALED",
						"CURSOR_BRIGHTNESS"}
TDC.controllers		= { {"parameter_in_range",				0, 1},
						{"move_left_right_using_parameter",	1, 180/math.pi*elem_scale*half_width},
						{"move_up_down_using_parameter",	2, mil5Scale*2*half_height},
						{"opacity_using_parameter",			3}}
Add(TDC) 

-- TDC Big
TDC_7					= CreateElement "ceTexPoly"
TDC_7.name				= "TDC_7"
TDC_7.init_pos			= {0, -5.9/2*elem_scale, 0}
TDC_7.vertices			= { {-5*elem_scale-elem_delta,   0*elem_scale-elem_delta},
							{-5*elem_scale-elem_delta, 5.9*elem_scale+elem_delta},
							{ 5*elem_scale+elem_delta, 5.9*elem_scale+elem_delta},
							{ 5*elem_scale+elem_delta,   0*elem_scale-elem_delta}}
TDC_7.indices 			= default_box_indices
TDC_7.tex_coords		= { { 20 * tex_scale-delta,	170 * tex_scale+delta},
							{ 20 * tex_scale-delta,	 20 * tex_scale-delta},
							{220 * tex_scale+delta,	 20 * tex_scale-delta},
							{220 * tex_scale+delta,	170 * tex_scale+delta}}
TDC_7.material			= IND_MATERIAL
TDC_7.use_mipfilter		= use_mipfilter
TDC_7.parent_element	= TDC.name
TDC_7.h_clip_relation	= h_clip_relations.COMPARE
TDC_7.level				= RADAR_DEFAULT_LEVEL
TDC_7.element_params	= {"RANGE_SCALE"}
TDC_7.controllers		= {{"parameter_in_range", 0, 0, 11}}			-- 5- and 10-mil
Add(TDC_7)

-- TDC Small
TDC_3					= CreateElement "ceTexPoly"
TDC_3.name				= "TDC_3"
TDC_3.init_pos			= {0, -2.95/2*elem_scale, 0}
TDC_3.vertices			= { {-5*elem_scale-elem_delta,    0*elem_scale-elem_delta},
							{-5*elem_scale-elem_delta, 2.95*elem_scale+elem_delta},
							{ 5*elem_scale+elem_delta, 2.95*elem_scale+elem_delta},
							{ 5*elem_scale+elem_delta,    0*elem_scale-elem_delta}}
TDC_3.indices 			= default_box_indices
TDC_3.tex_coords		= { {260 * tex_scale-delta,	 95 * tex_scale+delta},
							{260 * tex_scale-delta,	 20 * tex_scale-delta},
							{460 * tex_scale+delta,	 20 * tex_scale-delta},
							{460 * tex_scale+delta,	 95 * tex_scale+delta}}
TDC_3.material			= IND_MATERIAL
TDC_3.use_mipfilter		= use_mipfilter
TDC_3.parent_element	= TDC.name
TDC_3.h_clip_relation	= h_clip_relations.COMPARE
TDC_3.level				= RADAR_DEFAULT_LEVEL
TDC_3.element_params	= {"RANGE_SCALE"}
TDC_3.controllers		= {{"parameter_in_range", 0, 19, 21}}			-- 20-mil
Add(TDC_3)

-- Range Gate
range_gate					= CreateElement "ceTexPoly"
range_gate.name				= "range_gate"
range_gate.init_pos			= {ACQ_offset*elem_scale, -2.5*milToDeg*elem_scale/0.947, 0} 
range_gate.vertices			= { {-9*elem_scale-elem_delta, -0.4*elem_scale-elem_delta},
								{-9*elem_scale-elem_delta,  0.4*elem_scale+elem_delta},
								{ 9*elem_scale+elem_delta,  0.4*elem_scale+elem_delta},
								{ 9*elem_scale+elem_delta, -0.4*elem_scale-elem_delta}}
range_gate.indices 			= default_box_indices
range_gate.tex_coords		= { { 30 * tex_scale-delta,	370 * tex_scale+delta},
								{ 30 * tex_scale-delta,	350 * tex_scale-delta},
								{390 * tex_scale+delta,	350 * tex_scale-delta},
								{390 * tex_scale+delta,	370 * tex_scale+delta}}
range_gate.material			= IND_MATERIAL
range_gate.use_mipfilter	= use_mipfilter
range_gate.h_clip_relation	= h_clip_relations.COMPARE
range_gate.level			= RADAR_DEFAULT_LEVEL
range_gate.element_params	= {	"RADAR159_MODE",
								"SHOW_GATE",
								"RADAR_GATE_RANGE_SCALED"}
range_gate.controllers		= {	{"parameter_in_range",				0, 2.9,4.1},		-- ACQ and TRACKING
								{"parameter_in_range",				1, 1},
								{"move_up_down_using_parameter",	2, mil5Scale*2*half_height}}
Add(range_gate)

-- Target Marks + Ground Clutter
local function vertex_quad_center(W,H,C_X,C_Y)
	local C_X  = C_X or 0
	local C_Y  = C_Y or 0
	local UL_X = C_X - 0.3 * W
	local UL_Y = C_Y + 0.3 * H
	local DR_X = C_X + 0.3 * W
	local DR_Y = C_Y - 0.3 * H
	
	return 
	{ {UL_X ,UL_Y},
	  {DR_X ,UL_Y},
	  {DR_X ,DR_Y},
	  {UL_X ,DR_Y}
	}
end

local function texture_quad(UL_X,UL_Y,DR_X,DR_Y)
	return 
	{ {UL_X * tex_scale,UL_Y* tex_scale},
	  {DR_X * tex_scale,UL_Y* tex_scale},
	  {DR_X * tex_scale,DR_Y* tex_scale},
	  {UL_X * tex_scale,DR_Y* tex_scale}
	}
end


local function texture_quad_center(W,H,C_X,C_Y)
	local C_X  = C_X or 0
	local C_Y  = C_Y or 0
	
	local UL_X = C_X - 0.5 * W
	local UL_Y = C_Y - 0.5 * H
	local DR_X = C_X + 0.5 * W
	local DR_Y = C_Y + 0.5 * H
	return 
	{ {UL_X * tex_scale,UL_Y* tex_scale},
	  {DR_X * tex_scale,UL_Y* tex_scale},
	  {DR_X * tex_scale,DR_Y* tex_scale},
	  {UL_X * tex_scale,DR_Y* tex_scale}
	}
end

local function generate_mark_face(pfx,name)
	local mark				= CreateElement "ceTexPoly"
	if name then
		mark.name			= pfx..name
	else
		mark.name			= pfx
	end

	mark.init_pos			= {0, -2.5*milToDeg*elem_scale/0.947, 0}
	mark.vertices			= vertex_quad_center(9 * elem_scale + 2 * elem_delta, 1.5 * elem_scale + 2 * elem_delta);
	mark.indices 			= default_box_indices
	mark.tex_coords			= texture_quad(20,200,220,250)
	
	mark.material			= IND_MATERIAL
	mark.use_mipfilter		= use_mipfilter
	mark.parent_element		= SCAN_mode.name
	mark.h_clip_relation	= h_clip_relations.COMPARE
	mark.level				= RADAR_DEFAULT_LEVEL
	mark.element_params		= {	pfx.."TIME",
								pfx.."NOISE",
								pfx.."RANGE_SCALED",
								pfx.."AZIMUTH",
								pfx.."SIGNAL_STR"}
	Add(mark)
	return mark
end

function add_mark(index)
	local pfx 			 			= string.format("RADAR_CONTACT_%02d_",index)

	local mark_position				= generate_mark_face(pfx)
	mark_position.controllers		= {	{"parameter_in_range",				0, 0.0, 1.75},			-- check that mark is outdated
										{"parameter_in_range",				1, -1.0, 0.99},
										{"move_up_down_using_parameter"   ,	2, mil5Scale*2*half_height},	
										{"move_left_right_using_parameter",	3, 180/math.pi*elem_scale*half_width},
										{"opacity_using_parameter",			4}}
	
	local mark_noise			= generate_mark_face(pfx,"NOISE")
	mark_noise.controllers		= {	{"parameter_in_range",				0, 0.0, 1.75},			-- check that mark is outdated
									{"parameter_in_range",				1, 0.99, 2.0},
									{"move_up_down_using_parameter"   ,	2, mil5Scale*2*half_height},	
									{"move_left_right_using_parameter",	3, 180/math.pi*elem_scale*half_width},
									{"opacity_using_parameter",			4}}
end

for i = 1,512 do
	add_mark(i)
end

-- Indication TRACKING
locked_target					= CreateElement "ceTexPoly"
locked_target.name				= "locked_target"
locked_target.init_pos			= {ACQ_offset*elem_scale, -2.5*milToDeg*elem_scale/0.947, 0}
locked_target.vertices			= { {-4.5*elem_scale-elem_delta, -0.75*elem_scale-elem_delta},
									{-4.5*elem_scale-elem_delta,  0.75*elem_scale+elem_delta},
									{ 4.5*elem_scale+elem_delta,  0.75*elem_scale+elem_delta},
									{ 4.5*elem_scale+elem_delta, -0.75*elem_scale-elem_delta}}
locked_target.indices 			= default_box_indices
locked_target.tex_coords		= { {30 * tex_scale-delta,	210 * tex_scale-delta},
									{210 * tex_scale+delta,	210 * tex_scale-delta},
									{210 * tex_scale+delta,	240 * tex_scale+delta},
									{30 * tex_scale-delta,	240 * tex_scale+delta}}
locked_target.material			= IND_MATERIAL
locked_target.use_mipfilter		= use_mipfilter
locked_target.h_clip_relation	= h_clip_relations.COMPARE
locked_target.level				= RADAR_DEFAULT_LEVEL
locked_target.element_params	= {	"RADAR159_MODE",
									"RADAR_GATE_RANGE_SCALED"}
locked_target.controllers		= {	{"parameter_in_range",				0, 4},		-- TRACKING
									{"move_up_down_using_parameter",	1, mil5Scale*2*half_height}}
Add(locked_target)

-- Aim Symbol
aim_symbol					= CreateElement "ceTexPoly"
aim_symbol.name				= "aim_symbol"
aim_symbol.init_pos			= {0, 2*elem_scale, 0}
aim_symbol.vertices			= { {-2.5*elem_scale-elem_delta, -2.5*elem_scale-elem_delta},
								{-2.5*elem_scale-elem_delta,  2.5*elem_scale+elem_delta},
								{ 2.5*elem_scale+elem_delta,  2.5*elem_scale+elem_delta},
								{ 2.5*elem_scale+elem_delta, -2.5*elem_scale-elem_delta}}
aim_symbol.indices 			= default_box_indices
aim_symbol.tex_coords		= { {310 * tex_scale-delta,	210 * tex_scale-delta},
								{410 * tex_scale+delta,	210 * tex_scale-delta},
								{410 * tex_scale+delta,	310 * tex_scale+delta},
								{310 * tex_scale-delta,	310 * tex_scale+delta}}
aim_symbol.material			= IND_MATERIAL
aim_symbol.use_mipfilter	= use_mipfilter
aim_symbol.h_clip_relation	= h_clip_relations.COMPARE
aim_symbol.level			= RADAR_DEFAULT_LEVEL
aim_symbol.element_params	= {	"RADAR159_MODE",
								"SHOW_AIM_SYMBOL",
								"RADAR_STT_ELEVATION_STAB",
								"RADAR_STT_AZIMUTH_STAB",
								"CURSOR_BRIGHTNESS"}
aim_symbol.controllers		= {	{"parameter_in_range", 				0, 4}, -- 	TRACKING
								{"parameter_in_range",				1, 1},
								{"move_up_down_using_parameter"   ,	2, 180/math.pi*elem_scale*half_height},	
								{"move_left_right_using_parameter",	3, 180/math.pi*elem_scale*half_width},
								{"opacity_using_parameter",			4}}
Add(aim_symbol)
